unit Demoled;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Toggler, StdCtrls, Custbtn, Ledgadgt;

type
  TLEDControls = class(TForm)
    chkShowUnlit: TLEDCheckBox;
    LEDLabel1: TLEDLabel;
    ShadowButton1: TShadowButton;
    GroupBox1: TGroupBox;
    rbGreen: TLEDRadioButton;
    rbRed: TLEDRadioButton;
    rbCyan: TLEDRadioButton;
    procedure rbClick(Sender: TObject);
    procedure chkShowUnlitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure SetColors;
    procedure SetLabelUnlit;
  public
    { Public declarations }
  end;

var
  LEDControls: TLEDControls;

implementation

{$R *.DFM}
var
  colLit, colUnLit: TColor;

procedure TLEDControls.SetLabelUnlit;
begin
  if chkShowUnlit.Checked then
    LEDLabel1.UnLitColor := colUnLit
  else
    LEDLabel1.UnLitColor := clBlack;
end;

procedure TLEDControls.SetColors;
begin
  chkShowUnlit.LitColor := colLit;
  chkShowUnlit.UnLitColor := colUnLit;
  rbGreen.LitColor := colLit;
  rbGreen.UnLitColor := colUnLit;
  rbRed.LitColor := colLit;
  rbRed.UnLitColor := colUnLit;
  rbCyan.LitColor := colLit;
  rbCyan.UnLitColor := colUnLit;
  LEDLabel1.LitColor := colLit;
  SetLabelUnlit;
end;

procedure TLEDControls.rbClick(Sender: TObject);
begin
  if Sender = rbGreen then begin
    colLit := clLime;
    colUnLit := $00004000;
  end
  else if Sender = rbRed then begin
    colLit := clRed;
    colUnLit := $00000040;
  end
  else begin
    colLit := clAqua;
    colUnLit := $00808040;
  end;
  SetColors;
end;

procedure TLEDControls.chkShowUnlitClick(Sender: TObject);
begin
  SetLabelUnlit;
end;

procedure TLEDControls.FormCreate(Sender: TObject);
begin
  colLit := clLime;
  colUnLit := $00004000;
  SetColors;
end;

end.
